% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_chemokines.R
\name{compute_chemokines}
\alias{compute_chemokines}
\title{Compute chemokine signature (chemokines) score}
\usage{
compute_chemokines(matches, RNA_tpm)
}
\arguments{
\item{matches}{numeric vector indicating the index of signature
genes in \code{RNA_tpm}.}

\item{RNA_tpm}{data.frame containing TPM values with HGNC symbols
in rows and samples in columns.}
}
\value{
A numeric matrix with samples in rows and chemokines
score in a column.
}
\description{
Calculates chemokines score as the PC1 score that results
from applying PCA to the expression of its signature genes,
defined in Messina et al., Sci. Rep., 2012.
}
\references{
Messina, J.L., Fenstermacher, D.A., Eschrich, S.,
Qu, X., Berglund, A.E., Lloyd, M.C., Schell, M.J., Sondak, V.K.,
Weber, J.S., and Mule, J.J. (2012). 12-Chemokine gene signature
identifies lymph node-like structures in melanoma: potential for
patient selection for immunotherapy? Sci. Rep. 2, 765.
https://doi.org/10.1038/srep00765.
}
