% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_Tcell_inflamed.R
\name{compute_Tcell_inflamed}
\alias{compute_Tcell_inflamed}
\title{Compute T cell-inflamed signature (Tcell_inflamed)
score}
\usage{
compute_Tcell_inflamed(housekeeping, predictors, weights, RNA_tpm)
}
\arguments{
\item{housekeeping}{numeric vector indicating the index of
houskeeping genes in \code{RNA_tpm}.}

\item{predictors}{numeric vector indicating the index of
predictor genes in \code{RNA_tpm}.}

\item{weights}{numeric vector containing the weights.}

\item{RNA_tpm}{data.frame containing TPM values with HGNC
symbols in rows and samples in columns.}
}
\value{
A numeric matrix with samples in rows and Tcell_inflamed
score in a column.
}
\description{
Calculates Tcell_inflamed score using a weighted sum of
housekeeping normalized expression of its signature genes,
as defined in Cristescu et al., Science, 2018.
}
\details{
Weights were available at Table S2B from Cristescu R, et al.
Pan-tumor genomic biomarkers for PD-1 checkpoint blockade-based
immunotherapy. Science. (2018) 362:eaar3593.
doi: 10.1126/science.aar3593.
}
\references{
Ayers, M., Lunceford, J., Nebozhyn, M., Murphy,
E., Loboda, A., Kaufman, D.R., Albright, A., Cheng, J.D., Kang,
S.P., Shankaran, V., et al. (2017). IFN-y-related mRNA profile
predicts clinical response to PD-1 blockade. J. Clin. Invest.
127, 2930–2940. https://doi.org/10.1172/JCI91190.
}
