% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_TLS.R
\name{compute_TLS}
\alias{compute_TLS}
\title{Computation of tertiary lymphoid structures
signature (TLS) score}
\usage{
compute_TLS(matches, RNA_tpm)
}
\arguments{
\item{matches}{numeric vector indicating the index of
signature genes in \code{RNA_tpm}.}

\item{RNA_tpm}{data.frame containing TPM values with
HGNC symbols in rows and samples in columns.}
}
\value{
A numeric matrix with samples in rows and
TLS score in a column.
}
\description{
Calculates TLS score using the geometric-mean of the
expression of its signature genes, as defined in
Cabrita et al., Nature, 2020.
}
\references{
Cabrita, R., Lauss, M., Sanna, A., Donia, M.,
Skaarup Larsen, M., Mitra, S., Johansson, I., Phung, B.,
Harbst, K., Vallon-Christersson, J., et al. (2020).
Tertiary lymphoid structures improve immunotherapy and
survival in melanoma. Nature 577, 561–565.
}
