% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_Ayers_expIS.R
\name{compute_Ayers_expIS}
\alias{compute_Ayers_expIS}
\title{Compute Expanded Immune signature (Ayers_expIS) score}
\usage{
compute_Ayers_expIS(matches, RNA_tpm)
}
\arguments{
\item{matches}{numeric vector indicating the index of signature
genes in \code{RNA_tpm}.}

\item{RNA_tpm}{numeric matrix with rows=genes and columns=samples.}
}
\value{
A numeric matrix with rows=samples and
columns=Expanded Immune signature score.
}
\description{
Calculates Ayers_expIS score as the average expression
of its signature genes, as defined in Ayers et al., J.
Clin. Invest, 2017.
}
\references{
Ayers, M., Lunceford, J., Nebozhyn, M., Murphy,
E., Loboda, A., Kaufman, D.R., Albright, A., Cheng, J.D.,
Kang, S.P., Shankaran, V., et al. (2017). IFN-y-related mRN
A profile predicts clinical response to PD-1 blockade.
J. Clin. Invest. 127, 2930–2940.
https://doi.org/10.1172/JCI91190.
}
