% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyzeDuprates.R
\name{analyzeDuprates}
\alias{analyzeDuprates}
\title{Read in a BAM file and count the tags falling on the features described
in the GTF file}
\usage{
analyzeDuprates(
  bam,
  gtf,
  stranded = 0,
  paired = FALSE,
  threads = 1,
  verbose = FALSE,
  tmpDir = ".",
  ...
)
}
\arguments{
\item{bam}{The bam file containing the duplicate-marked reads}

\item{gtf}{The gtf file describing the features}

\item{stranded}{Whether the reads are strand specific}

\item{paired}{Paired end experiment?}

\item{threads}{The number of threads to be used for counting}

\item{verbose}{Whether to output Rsubread messages into the console}

\item{tmpDir}{Directory for temporary files created by featureCounts (default: ".")}

\item{...}{Other params sent to featureCounts}
}
\value{
A data.frame with counts on features, with and without taking into
  account multimappers/duplicated reads
}
\description{
\code{analyzeDuprates} returns a data.frame with tag counts
}
\details{
This function makes use of the Rsubread package to count tags on the GTF
features in different scenarios. The scenarios are the 4 possible
combinations of allowing multimappers (yes/no) and duplicate reads (yes/no).
}
\examples{
bam <- system.file("extdata",
    "wgEncodeCaltechRnaSeqGm12878R1x75dAlignsRep2V2_duprm.bam",
    package = "dupRadar"
)
gtf <- system.file("extdata", "genes.gtf", package = "dupRadar")
stranded <- 2 # '0' (unstranded), '1' (stranded) and '2' (reverse)
paired <- FALSE
threads <- 4

# call the duplicate marker and analyze the reads
dm <- analyzeDuprates(bam, gtf, stranded, paired, threads)

# use a different directory for temporary files (e.g., for FUSE filesystem issues)
dm <- analyzeDuprates(bam, gtf, stranded, paired, threads, tmpDir = "/tmp")
}
