% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zenith_gsa.R
\name{zenith_gsa,dreamletResult,GeneSetCollection-method}
\alias{zenith_gsa,dreamletResult,GeneSetCollection-method}
\alias{zenith_gsa,dreamletResult,GeneSetCollection,ANY-method}
\alias{zenith_gsa,dreamlet_mash_result,GeneSetCollection-method}
\alias{zenith_gsa,dreamlet_mash_result,GeneSetCollection,ANY-method}
\title{Perform gene set analysis using zenith}
\usage{
\S4method{zenith_gsa}{dreamletResult,GeneSetCollection}(
  fit,
  geneSets,
  coefs,
  use.ranks = FALSE,
  n_genes_min = 10,
  inter.gene.cor = 0.01,
  progressbar = TRUE,
  ...
)

\S4method{zenith_gsa}{dreamlet_mash_result,GeneSetCollection}(
  fit,
  geneSets,
  coefs,
  use.ranks = FALSE,
  n_genes_min = 10,
  inter.gene.cor = 0.01,
  progressbar = TRUE,
  ...
)
}
\arguments{
\item{fit}{results from \code{dreamlet()}}

\item{geneSets}{\code{GeneSetCollection}}

\item{coefs}{coefficients to test using \code{topTable(fit, coef=coefs[i])}}

\item{use.ranks}{do a rank-based test \code{TRUE} or a parametric test \code{FALSE}? default: FALSE}

\item{n_genes_min}{minimum number of genes in a geneset}

\item{inter.gene.cor}{if NA, estimate correlation from data.  Otherwise, use specified value}

\item{progressbar}{if TRUE, show progress bar}

\item{...}{other arguments}
}
\value{
\code{data.frame} of results for each gene set and cell type

\code{data.frame} of results for each gene set and cell type
}
\description{
Perform a competitive gene set analysis accounting for correlation between genes.
}
\details{
This code adapts the widely used \code{camera()} analysis \insertCite{wu2012camera}{zenith} in the \code{limma} package \insertCite{ritchie2015limma}{zenith} to the case of linear (mixed) models used by \code{variancePartition::dream()}.
}
\examples{
library(muscat)
library(SingleCellExperiment)

data(example_sce)

# create pseudobulk for each sample and cell cluster
pb <- aggregateToPseudoBulk(example_sce,
  assay = "counts",
  cluster_id = "cluster_id",
  sample_id = "sample_id",
  verbose = FALSE
)

# voom-style normalization
res.proc <- processAssays(pb, ~group_id)

# Differential expression analysis within each assay,
# evaluated on the voom normalized data
res.dl <- dreamlet(res.proc, ~group_id)

# Load Gene Ontology database
# use gene 'SYMBOL', or 'ENSEMBL' id
# use get_MSigDB() to load MSigDB
library(zenith)
go.gs <- get_GeneOntology("CC", to = "SYMBOL")

# Run zenith gene set analysis on result of dreamlet
res_zenith <- zenith_gsa(res.dl, go.gs, "group_idstim", progressbar = FALSE)

# for each cell type select 3 genesets with largest t-statistic
# and 1 geneset with the lowest
# Grey boxes indicate the gene set could not be evaluted because
#    to few genes were represented
plotZenithResults(res_zenith, 3, 1)

}
