% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpDF.R
\name{sortCols,vpDF-method}
\alias{sortCols,vpDF-method}
\title{Sort variance partition statistics}
\usage{
\S4method{sortCols}{vpDF}(
  x,
  FUN = sum,
  decreasing = TRUE,
  last = c("Residuals", "Measurement.error"),
  ...
)
}
\arguments{
\item{x}{object returned by \code{fitVarPart()}}

\item{FUN}{function giving summary statistic to sort by.  Defaults to sum}

\item{decreasing}{logical.  Should the sorting be increasing or decreasing?}

\item{last}{columns to be placed on the right, regardless of values in these columns}

\item{...}{other arguments to sort}
}
\value{
\code{data.frame} with columns sorted by mean value, with Residuals in last column
}
\description{
Sort variance partition statistics
}
\examples{
library(muscat)
library(SingleCellExperiment)

data(example_sce)

# create pseudobulk for each sample and cell cluster
pb <- aggregateToPseudoBulk(example_sce,
  assay = "counts",
  cluster_id = "cluster_id",
  sample_id = "sample_id",
  verbose = FALSE
)

# voom-style normalization
res.proc <- processAssays(pb, ~group_id)

# variance partitioning analysis
vp <- fitVarPart(res.proc, ~group_id)

# Summarize variance fractions genome-wide for each cell type
plotVarPart(sortCols(vp))

}
