% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotProjection.R
\name{plotProjection}
\alias{plotProjection}
\title{Plot 2D projection}
\usage{
plotProjection(
  sce,
  type,
  annotation,
  pointsize = 0,
  pixels = c(512, 512),
  legend.position = "none",
  text = TRUE,
  order
)
}
\arguments{
\item{sce}{\code{SingleCellExperiment}}

\item{type}{field in \code{reducedDims(sce)} to plot}

\item{annotation}{column in \code{colData(sce)} to annotate each cell}

\item{pointsize}{Radius of rasterized point. Use \code{0} for single pixels(fastest).}

\item{pixels}{Vector with X and Y resolution of the raster, default \code{c(512,512)}}

\item{legend.position}{legend.position: the position of legends ("none", "left", "right", "bottom", "top", or two-element numeric vector)}

\item{text}{show \code{annotation} as text. Default \code{TRUE}}

\item{order}{specify order of levels for \code{annotation}}
}
\value{
ggplot2 plot of the projection
}
\description{
Plot 2D projection (i.e. UMAP, tSNE) for millions of cells efficiently
}
\details{
Uses \code{scattermore::geom_scattermore()} to plot millions of points efficiently
}
\examples{
library(muscat)
library(SingleCellExperiment)

data(example_sce)

plotProjection(example_sce, "TSNE", "cluster_id", 1)
}
