% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier.R
\name{outlierByAssay}
\alias{outlierByAssay}
\title{Outlier analysis for each assay}
\usage{
outlierByAssay(object, assays = names(object), nPC = 2, robust = FALSE, ...)
}
\arguments{
\item{object}{\code{dreamletProcessedData} from \code{processAssays()}}

\item{assays}{assays / cell types to analyze}

\item{nPC}{number of PCs to uses for outlier score with \code{outlier()}}

\item{robust}{use robust covariance method, defaults to \code{FALSE}}

\item{...}{arguments passed to \code{MASS::cov.rob()}}
}
\value{
\describe{
 \item{\code{ID}:}{sample identifier}
 \item{\code{assay}:}{specify assay}
 \item{\code{PCs}:}{principal components}
 \item{\code{chisq}:}{mahalanobis distance that is distributed as chisq(k) k = nPC if the data is multivariate gaussian}
 \item{\code{z}:}{z-score corresponding to the chisq distance}
}
}
\description{
Compute outlier score for each sample in each assay using \code{outlier()} run on the top principal components.  Mahalanobis distance is used for outlier detect and multivariate normal assumption is used to compute p-values
}
\examples{
library(muscat)
library(SingleCellExperiment)

data(example_sce)

# create pseudobulk for each sample and cell cluster
pb <- aggregateToPseudoBulk(example_sce,
  assay = "counts",
  cluster_id = "cluster_id",
  sample_id = "sample_id",
  verbose = FALSE
)

# voom-style normalization
res.proc <- processAssays(pb, ~group_id)

# Compute PCs and outlier scores
outlierByAssay( res.proc, c("B cells", "CD14+ Monocytes")) 
}
\seealso{
\code{outlier()}
}
