% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dreamlet.R
\name{dreamlet}
\alias{dreamlet}
\alias{dreamlet,dreamletProcessedData-method}
\title{Differential expression for each assay}
\usage{
dreamlet(
  x,
  formula,
  data = colData(x),
  assays = assayNames(x),
  contrasts = NULL,
  min.cells = 10,
  robust = FALSE,
  quiet = FALSE,
  BPPARAM = SerialParam(),
  use.eBayes = TRUE,
  ...
)

\S4method{dreamlet}{dreamletProcessedData}(
  x,
  formula,
  data = colData(x),
  assays = assayNames(x),
  contrasts = NULL,
  min.cells = 10,
  robust = FALSE,
  quiet = FALSE,
  BPPARAM = SerialParam(),
  use.eBayes = TRUE,
  ...
)
}
\arguments{
\item{x}{SingleCellExperiment or dreamletProcessedData object}

\item{formula}{regression formula for differential expression analysis}

\item{data}{metadata used in regression formula}

\item{assays}{array of assay names to include in analysis. Defaults to \code{assayNames(x)}}

\item{contrasts}{character vector specifying contrasts specifying linear combinations of fixed effects to test.  This is fed into \code{makeContrastsDream( formula, data, contrasts=contrasts)}}

\item{min.cells}{minimum number of observed cells for a sample to be included in the analysis}

\item{robust}{logical, use eBayes method that is robust to outlier genes}

\item{quiet}{show messages}

\item{BPPARAM}{parameters for parallel evaluation}

\item{use.eBayes}{should \code{eBayes} be used on result? (defualt: TRUE)}

\item{...}{other arguments passed to \code{dream}}
}
\value{
Object of class \code{dreamletResult} storing results for each cell type
}
\description{
Perform differential expression for each assay using linear (mixed) models
}
\details{
Fit linear (mixed) model on each cell type separately.  For advanced use of contrasts see \code{variancePartition::makeContrastsDream()} and vignette \url{https://gabrielhoffman.github.io/variancePartition/articles/dream.html#advanced-hypothesis-testing-1}.
}
\examples{
library(muscat)
library(SingleCellExperiment)

data(example_sce)

# create pseudobulk for each sample and cell cluster
pb <- aggregateToPseudoBulk(example_sce,
  assay = "counts",
  cluster_id = "cluster_id",
  sample_id = "sample_id",
  verbose = FALSE
)

# voom-style normalization
res.proc <- processAssays(pb, ~group_id)

# Differential expression analysis within each assay,
# evaluated on the voom normalized data
res.dl <- dreamlet(res.proc, ~group_id)

# Examine results
res.dl

# Examine details for each assay
details(res.dl)

# show coefficients estimated for each cell type
coefNames(res.dl)

# extract results using limma-style syntax
# combines all cell types together
# adj.P.Val gives study-wide FDR
topTable(res.dl, coef = "group_idstim", number = 3)

}
\seealso{
\code{variancePartition::dream()}, \code{variancePartition::makeContrastsDream()}
}
