% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dreamletProcessedData.R, R/vpDF.R
\name{details}
\alias{details}
\alias{details,dreamletProcessedData-method}
\alias{details,dreamletResult-method}
\alias{details,vpDF-method}
\title{Extract details from dreamletProcessedData}
\usage{
details(object)

\S4method{details}{dreamletProcessedData}(object)

\S4method{details}{dreamletResult}(object)

\S4method{details}{vpDF}(object)
}
\arguments{
\item{object}{A \code{dreamletProcessedData} object}
}
\value{
Extract detailed information from some classes
}
\description{
Extract details from \code{dreamletProcessedData}
}
\examples{
library(muscat)
library(SingleCellExperiment)

data(example_sce)

# create pseudobulk for each sample and cell cluster
pb <- aggregateToPseudoBulk(example_sce,
  assay = "counts",
  cluster_id = "cluster_id",
  sample_id = "sample_id",
  verbose = FALSE
)

# voom-style normalization
res.proc <- processAssays(pb, ~group_id)

# For each cell type, number of samples retained,
# and variables retained
details(res.proc)

}
