% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeLogCPM.R
\name{computeLogCPM}
\alias{computeLogCPM}
\title{Compute log normalized counts}
\usage{
computeLogCPM(
  sce,
  lib.size = colSums2(counts(sce)),
  prior.count = 2,
  scaledByLib = FALSE
)
}
\arguments{
\item{sce}{\code{SingleCellExperiment} with counts stored as \code{counts(sce)}}

\item{lib.size}{library size for each cell}

\item{prior.count}{average count to be added to each observation to avoid taking log of zero}

\item{scaledByLib}{if \code{TRUE}, scale pseudocount by \code{lib.size}.  Else do standard constant pseudocount addition}
}
\value{
matrix of log CPM values
}
\description{
Compute normalized counts as log2 counts per million
}
\details{
This function gives same result as \code{edgeR::cpm(counts(sce), log=TRUE)}
}
\examples{
library(muscat)
library(SingleCellExperiment)

data(example_sce)

logcounts(example_sce) <- computeLogCPM(example_sce)
}
\seealso{
also \code{edgeR::cpm()}
}
