% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dreamlet.R
\name{coefNames}
\alias{coefNames}
\alias{coefNames,dreamletResult-method}
\title{Get coefficient names}
\usage{
coefNames(obj)

\S4method{coefNames}{dreamletResult}(obj)
}
\arguments{
\item{obj}{A \code{dreamletResult} object}
}
\value{
array storing names of coefficients
}
\description{
Get coefficient names
}
\examples{
library(muscat)
library(SingleCellExperiment)

data(example_sce)

# create pseudobulk for each sample and cell cluster
pb <- aggregateToPseudoBulk(example_sce,
  assay = "counts",
  cluster_id = "cluster_id",
  sample_id = "sample_id",
  verbose = FALSE
)

# voom-style normalization
res.proc <- processAssays(pb, ~group_id)

# Differential expression analysis within each assay,
# evaluated on the voom normalized data
res.dl <- dreamlet(res.proc, ~group_id)

# show coefficients estimated for each cell type
coefNames(res.dl)

}
