% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildClusterTreeFromPB.R
\name{buildClusterTreeFromPB}
\alias{buildClusterTreeFromPB}
\title{Hierarchical clustering on cell types from pseudobulk}
\usage{
buildClusterTreeFromPB(
  pb,
  method = c("complete", "ward.D", "single", "average", "mcquitty", "median", "centroid",
    "ward.D2"),
  dist.method = c("euclidean", "maximum", "manhattan", "canberra", "binary", "minkowski"),
  assays = assayNames(pb)
)
}
\arguments{
\item{pb}{\code{SingleCellObject} storing pseudobulk for each cell type in in \code{assay()} field}

\item{method}{clustering method for \code{hclust()}}

\item{dist.method}{distance metric}

\item{assays}{which assays to include}
}
\value{
hierarchical clustering object of class \code{hclust}
}
\description{
Perform hierarchical clustering on cell types from pseudobulk by aggregating read counts from each cell type.
}
\examples{
library(muscat)
library(SingleCellExperiment)

data(example_sce)

# create pseudobulk for each sample and cell cluster
pb <- aggregateToPseudoBulk(example_sce,
  assay = "counts",
  cluster_id = "cluster_id",
  sample_id = "sample_id",
  verbose = FALSE
)

# Hierarchical clustering of cell types
hcl <- buildClusterTreeFromPB(pb)

plot(hcl)

}
