% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoms.R
\name{draw_regions}
\alias{draw_regions}
\title{Add protein region sites to ggplot2 object.}
\usage{
draw_regions(p, data = data, show.legend=TRUE)
}
\arguments{
\item{p}{ggplot2 object ideally created with \code{\link{draw_canvas}}.}

\item{data}{Dataframe of one or more rows with the following column
names: 'type', 'description', 'begin', 'end', 'length', 'accession',
'entryName', 'taxid', 'order'. Must contain a minimum of one "CHAIN" as
data$type.}

\item{show.legend}{Option to include legend in this layer}
}
\value{
A ggplot2 object either in the plot window or as an object with an
additional geom_rect layer.
}
\description{
\code{draw_regions} adds protein regions from Uniprot to ggplot2 object
created by \code{\link{draw_canvas}} \code{\link{draw_chains}}.
It uses the data object.
The ggplot2 function \code{geom_rect} is used to draw each of the
regions proportional to their number of amino acids (length).
}
\examples{
# combines with draw_chains to plot chains and regions.
data("five_rel_data")
p <- draw_canvas(five_rel_data)
p <- draw_chains(p, five_rel_data, label_size = 1.25)
draw_regions(p, five_rel_data)

}
