% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoms.R
\name{draw_chains}
\alias{draw_chains}
\title{Create ggplot2 object with protein chains from feature database}
\usage{
draw_chains(p, data = data,
    outline = "black", fill = "grey",
    label_chains = TRUE, labels = data[data$type == "CHAIN",]$entryName,
    size = 0.5, label_size = 4)
}
\arguments{
\item{p}{ggplot2 object ideally created with \code{\link{draw_canvas}}.}

\item{data}{Dataframe of one or more rows with the following column
names: 'type', 'description', 'begin', 'end', 'length', 'accession',
'entryName', 'taxid', 'order'. Must contain a minimum of one "CHAIN" as
data$type.}

\item{outline}{Colour of the outline of each chain.}

\item{fill}{Colour of the fill of each chain.}

\item{label_chains}{Option to label chains or not.}

\item{labels}{Vector with source of names for the chains. EntryName used as
default but can be changed.}

\item{size}{Size of the outline of the chains.}

\item{label_size}{Size of the text used for labels.}
}
\value{
A ggplot2 object either in the plot window or as an object.
}
\description{
\code{draw_chains} uses the dataframe containing the protein features to
plot the chains, the full length proteins. It creates the basic plot element
by determining the length of the longest protein. The ggplot2 function
\code{geom_rect} is then used to draw each of the protein
chains proportional to their number of amino acids (length).
}
\examples{
# combines with draw_canvas to plot and label chains.
data("five_rel_data")
p <- draw_canvas(five_rel_data)
draw_chains(p, five_rel_data)

# draws five chains with different colours to default
data("five_rel_data")
p <- draw_canvas(five_rel_data)
draw_chains(p, five_rel_data,
    label_chains = FALSE,
    fill = "red",
    outline = "grey")

}
