#' Features of five human Rel A proteins
#'
#' List of features from five human NFkappaB proteins downloaded from
#' Uniprot on 15 August 2017
#'
#' @format Large List of 5 elements - one element for each protein
#' @return Large List of 5 elements - one element for each protein
#' @source Uniprot {http://www.uniprot.org}
#' Accession numbers Q04206 Q01201 Q04864 P19838 Q00653
"five_rel_list"

#' Dataframe features of 5 human NFkappaB proteins Uniprot on 1 Nov 2017
#'
#' @format A data frame with 320 rows and 9 variables:
#' \describe{
#'     \item{type}{type of features - e.g. chain}
#'     \item{description}{long name for the protein}
#'     \item{begin}{starting position (amino acid number) of feature}
#'     \item{end}{ending position (amino acid number) of feature}
#'     \item{length}{length of feature - number of amino acids}
#'     \item{accession}{protein Uniprot accession number}
#'     \item{entryName}{protein Uniprot entry Name}
#'     \item{taxid}{taxonomic identification - species}
#'     \item{order}{plotting order from the bottom of the graph}
#' }
#' @return A data frame with 320 rows and 9 variables
#' @source Uniprot {http://www.uniprot.org}
#' Accession numbers Q04206 Q01201 Q04864 P19838 Q00653
"five_rel_data"

#' Features of human Rel A protein
#'
#' List of features from human Rel A downloaded from
#' Uniprot on 15 August 2017
#'
#' @format List of 6 - information necessary to draw Rel A/p65
#' @return List of 6 - information necessary to draw Rel A/p65
#' @source \url{http://www.uniprot.org/uniprot/Q04206}
"rel_A_features"

#' Uniprot infor human Rel A protein in JSON format
#'
#' Large list (968.8 Kb) of information about human Rel A downloaded from
#' Uniprot on 1 November 2017
#'
#' @format List of 1 with List of 14 inside
#' @return List of 6 - information necessary to draw Rel A/p65
#' @source \url{http://www.uniprot.org/uniprot/Q04206}
"protein_json"

#' Human Rel A protein features in JSON format
#'
#' List of 1 with List of 6 inside downloaded from
#' Uniprot on 1 November 2017
#'
#' @format List of 1 with List of 6 - information necessary to draw Rel A/p65
#' @return List of 1 with List of 6 - information necessary to draw Rel A/p65
#' @source \url{http://www.uniprot.org/uniprot/Q04206}
"rel_json"

#' Dataframe features of 2 human TNF receptors from Uniprot on 3 Jan 2018
#'
#' @format A data frame with 127 rows of 9 variables:
#' \describe{
#'     \item{type}{type of features - e.g. chain}
#'     \item{description}{long name for the protein}
#'     \item{begin}{starting position (amino acid number) of feature}
#'     \item{end}{ending position (amino acid number) of feature}
#'     \item{length}{length of feature - number of amino acids}
#'     \item{accession}{protein Uniprot accession number}
#'     \item{entryName}{protein Uniprot entry Name}
#'     \item{taxid}{taxonomic identification - species}
#'     \item{order}{plotting order from the bottom of the graph}
#' }
#' @return A data frame with 127 rows and 9 variables
#' @source Uniprot {http://www.uniprot.org}
#' Accession numbers P19438 P25942
"tnfs_data"

NULL
