% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_rates_by_species}
\alias{plot_rates_by_species}
\title{Plot distributions of substitution rates (Ka, Ks, or Ka/Ks) per species}
\usage{
plot_rates_by_species(
  kaks_list,
  rate_column = "Ks",
  bytype = FALSE,
  range = c(0, 2),
  fill = "deepskyblue3",
  color = "deepskyblue4"
)
}
\arguments{
\item{kaks_list}{A list of data frames with substitution rates per gene
pair in each species as returned by \code{pairs2kaks()}.}

\item{rate_column}{Character indicating the name of the column to plot.
Default: "Ks".}

\item{bytype}{Logical indicating whether or not to show distributions by
type of duplication. Default: FALSE.}

\item{range}{Numeric vector of length 2 indicating the minimum and maximum
values to plot. Default: \code{c(0, 2)}.}

\item{fill}{Character with color to use for the fill aesthetic. Ignored
if \strong{bytype = TRUE}. Default: "deepskyblue3".}

\item{color}{Character with color to use for the color aesthetic. Ignored
if \strong{bytype = FALSE}. Default: "deepskyblue4".}
}
\value{
A ggplot object.
}
\description{
Plot distributions of substitution rates (Ka, Ks, or Ka/Ks) per species
}
\details{
Data will be plotted using the species order of the list. To change the
order of the species to plot, reorder the list elements
in \strong{kaks_list}.
}
\examples{
data(fungi_kaks)

# Plot rates
plot_rates_by_species(fungi_kaks, rate_column = "Ka_Ks") 
}
