% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculations_centmass.R
\name{centmass}
\alias{centmass}
\title{Compute the "center of mass" for rows of a data frame or SummarizedExperiment}
\usage{
centmass(
  x,
  x_coord = c(0, 1, 0.5),
  y_coord = c(0, 0, sqrt(3)/2),
  assay_name = NULL
)
}
\arguments{
\item{x}{A data.frame (with numeric columns) or a SummarizedExperiment.}

\item{x_coord}{Numeric vector of length equal to the number of columns
in \code{x}, specifying the x-coordinates of each column's mass.}

\item{y_coord}{Numeric vector of length equal to the number of columns
in \code{x}, specifying the y-coordinates of each column's mass.}

\item{assay_name}{If \code{x} is a SummarizedExperiment, the name of the
assay to use. Defaults to the first assay if not specified.}
}
\value{
\itemize{
  \item If \code{x} is a data.frame, returns a new \code{data.frame} with
    columns \code{comx} and \code{comy}.
  \item If \code{x} is a SummarizedExperiment, returns the same object but
    with two new columns \code{comx} and \code{comy} in \code{rowData(x)}.
}
}
\description{
For each row of the numeric data, \code{centmass()} computes a 2D center of
mass with coordinates (\code{comx}, \code{comy}). The \code{x_coord} and
\code{y_coord} vectors specify the location for each column's "mass."

The original usage assumes a ternary coordinate system by default, but this
can be generalized to any scenario where columns represent discrete "masses"
at known (x,y) positions.

By default, \code{x_coord = c(0, 1, 0.5)} and
\code{y_coord = c(0, 0, sqrt(3)/2)}, which correspond to the corners
of an equilateral triangle (often used in ternary plots).
}
\examples{
library(SummarizedExperiment)
library(airway)
data('airway')

se = airway

# Only use a random subset of 1000 rows
set.seed(123)
idx <- sample(seq_len(nrow(se)), size = min(1000, nrow(se)))
se <- se[idx, ]

# Let's subset for the first 3 columns for this example
se = se[,1:3]
# -------------------------------
# 1) Using a data.frame
# -------------------------------


df = assay(se) |> as.data.frame()

df = centmass(df)
head(df)

# -------------------------------
# 2) Using a SummarizedExperiment
# -------------------------------

se2 = centmass(se)

## X and Y coordinates are stored in rowData(se2)
head(rowData(se2))


}
