% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta-getters.R
\name{getMetas}
\alias{getMetas}
\title{Returns the names of all meta.data slots of a target object.}
\usage{
getMetas(object, names.only = TRUE)
}
\arguments{
\item{object}{A Seurat, SingleCellExperiment, or SummarizedExperiment object.}

\item{names.only}{Logical, \code{TRUE} by default, which sets whether just the names should be output versus the entire metadata dataframe.}
}
\value{
A string vector of the names of all metadata slots of the \code{object}, or alternatively the entire dataframe of metadatas if \code{names.only} is set to \code{FALSE}
}
\description{
Returns the names of all meta.data slots of a target object.
}
\examples{
example(importDittoBulk, echo = FALSE)

# To see all metadata slots of an object
getMetas(myRNA)

# To retrieve the entire metadata matrix
getMetas(myRNA, names.only = FALSE)

}
\seealso{
\code{\link{isMeta}} for checking if certain metadata slots exist in an \code{object}

\code{\link{meta}} for obtaining the contants of metadata slots
}
\author{
Daniel Bunis
}
