#' Example breast miRNA-Seq count dataset.
#' 
#' This dataset contains TMM normalized voom-transformed miRNA count values from
#' miRNASeq that was taken from the Cancer Genome Atlas, or TCGA. The dataset 
#' has 100 miRNA and 57 samples. The original dataset has 212 miRNA and 
#' 57 samples.
#' 
#' @docType data
#' @format An ExpressionSet with 100 features, 57 samples
#' @keywords datasets
#' @references National Institutes of Health. The Cancer Genome Atlas.
#' @source \url{http://cancergenome.nih.gov/}
#' @usage data(TCGA_Breast_miRNASeq)
#' @examples 
#'   data(TCGA_Breast_miRNASeq)
"TCGA_Breast_miRNASeq"

#' Example breast miRNA-Seq voom-transformed count dataset.
#' 
#' This dataset contains TMM normalized voom-transformed miRNA count values
#' from miRNASeq that was taken from the Cancer Genome Atlas, or TCGA. The
#' dataset has 100 miRNA and 57 samples. The original dataset has 212 miRNA and
#' 57 samples.
#'
#' @docType data
#' @format An ExpressionSet with 100 features and 57 samples
#' @references 
#' Charity W Law, Yunshun Chen, Wei Shi, Gordon K Smyth. voom: 
#' precision weights unlock linear model analysis tools for RNA-seq read 
#' counts. 2014. Genome Biology, 15:R29.
#'   
#' National Institues of Health. The Cancer Genome Atlas.
#' @source \url{http://cancergenome.nih.gov/}
#' @usage data(TCGA_Breast_miRNASeq_voom)
#' @examples 
#'   data(TCGA_Breast_miRNASeq_voom)
"TCGA_Breast_miRNASeq_voom"

#' TCGA Breast Cancer RNASeq Sample Dataset
#' 
#' This dataset contains TMM normalized RNA count values from RNASeq that was
#' taken from the Cancer Genome Atlas, or TCGA. It has 100 features and 57
#' samples. The original dataset had 17972 features and 57 samples.
#'
#' @docType data
#' @format An ExpressionSet with 100 features and 57 samples
#' @references 
#' Charity W Law, Yunshun Chen, Wei Shi, Gordon K Smyth. voom: 
#' precision weights unlock linear model analysis tools for RNA-seq read 
#' counts. 2014. Genome Biology, 15:R29.
#'   
#' National Institues of Health. The Cancer Genome Atlas.
#' @source \url{http://cancergenome.nih.gov/}
#' @usage data(TCGA_Breast_RNASeq)
#' @examples 
#'   data(TCGA_Breast_RNASeq)
"TCGA_Breast_RNASeq"

#' TCGA Breast Cancer RNASeq Sample Dataset
#' 
#' This dataset contains TMM normalized voom-transformed RNA count values from
#' RNASeq that was taken from the Cancer Genome Atlas, or TCGA.
#'  
#' @docType data
#' @format  An ExpressionSet with 100 features and 57 samples
#' @references 
#' Charity W Law, Yunshun Chen, Wei Shi, Gordon K Smyth. voom: precision 
#' weights unlock linear model analysis tools for RNA-seq read counts. 2014. 
#' Genome Biology, 15:R29.
#' 
#' National Institues of Health. The Cancer Genome Atlas.
#' @source \url{http://cancergenome.nih.gov/}
#' @usage data(TCGA_Breast_miRNASeq_voom)
#' @examples
#'   data(TCGA_Breast_miRNASeq_voom)
"TCGA_Breast_RNASeq_voom"

#' TCGA Glioblastoma Multiforme miRNA Sample Dataset
#' 
#' This dataset contains miRNA expression values from a microarray that was
#' taken from the Cancer Genome Atlas, or TCGA. It has 10 features and 30
#' samples. The original dataset had 331 features and 30 samples.
#' 
#' @docType data
#' @format An ExpressionSet with 10 features, 30 samples
#' @keywords datasets
#' @references National Institutes of Health. The Cancer Genome Atlas.
#' @source \url{http://cancergenome.nih.gov/}
#' @usage data(TCGA_GBM_miRNA_microarray)
#' @examples 
#'   data(TCGA_GBM_miRNA_microarray)
"TCGA_GBM_miRNA_microarray"

#' TCGA Glioblastoma Multiforme Transcript Sample Dataset
#' 
#' This dataset contains transcript expression values from a microarray that was
#'  taken from the Cancer Genome Atlas, or TCGA. It has 10 features and 30 
#'  samples. The original dataset had 72656 features and 30 samples.
#' 
#' @docType data
#' @format An ExpressionSet with 10 features, 30 samples
#' @keywords datasets
#' @references National Institutes of Health. The Cancer Genome Atlas.
#' @source \url{http://cancergenome.nih.gov/}
#' @usage data(TCGA_GBM_transcript_microarray)
#' @examples 
#'   data(TCGA_GBM_transcript_microarray)
"TCGA_GBM_transcript_microarray"



