% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diNOMeTest.R
\name{diNOMeTest}
\alias{diNOMeTest}
\title{diNOMeTest}
\usage{
diNOMeTest(
  footprint_counts,
  WTsamples = c("WT_1", "WT_2"),
  KOsamples = c("KO_1", "KO_2"),
  minreads = 1,
  meanreads = 1,
  prior.count = 3,
  FDR = 0.05,
  FC = 2,
  combineNucCounts = FALSE
)
}
\arguments{
\item{footprint_counts}{A Summarized Experiment containing the
sample names (colData), ROI names (rowData),
and number of fragments in each NOMe footprint pattern
category (assays). For example
the output of the (\code{footprintQuant}) function.}

\item{WTsamples}{The control sample names as they appear in
(\code{colData(footprint_counts)$samples}).}

\item{KOsamples}{The treatment sample names as they appear
in (\code{colData(footprint_counts)$samples}).}

\item{minreads}{The minimum number of fragments to which
a footprint could be assigned a ROI must have in all
samples. All other ROIs are filtered
out before the differential NOMe analysis.}

\item{meanreads}{The minimum number of fragments to which
a footprint could be assigned a ROI must on average across
all samples. All other ROIs are filtered out before
the differential NOMe analysis.}

\item{prior.count}{The pseudocount used for (\code{edgeR::glmQLFit}).}

\item{FDR}{The FDR cutoff for a ROI - footprint combination to be
called regulated in the output.}

\item{FC}{The fold change cutoff for a ROI - footprint combination
to be called regulated in the output.}

\item{combineNucCounts}{If TRUE, the upNuc, downNuc, and Nuc
fragment counts will be combined into the Nuc category.}
}
\value{
A tibble with the results of differential fragment
count testing for each ROI-footprint combination.
}
\description{
Tests for differences in fragment counts for each NOMe
footprint pattern compared to total fragment counts in two conditions.
}
\details{
Uses edgeR's quasi-likelihood methods to conveniently test
for differential proportions of each
one of 5 (or 3, if nucleosome footprints are combined) distinct
footprints between at least two control and at least two treatment samples.
}
\examples{
NomeData <- createExampleData()
NomeData <- footprintCalc(NomeData)
footprint_counts <- footprintQuant(NomeData)
diNOMeTest(footprint_counts,
    WTsamples = c("WT_1", "WT_2"),
    KOsamples = c("KO_1", "KO_2")
)

}
