% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/0classes.R
\docType{methods}
\name{print,diggit-method}
\alias{diggitAqtl}
\alias{diggitAqtl,diggit-method}
\alias{diggitCNV}
\alias{diggitCNV,diggit-method}
\alias{diggitConditional}
\alias{diggitConditional,diggit-method}
\alias{diggitFcnv}
\alias{diggitFcnv,diggit-method}
\alias{diggitMR}
\alias{diggitMR,diggit-method}
\alias{diggitMindy}
\alias{diggitMindy,diggit-method}
\alias{diggitRegulon}
\alias{diggitRegulon,diggit-method}
\alias{diggitViper}
\alias{diggitViper,diggit-method}
\alias{exprs,diggit-method}
\alias{exprs.diggit}
\alias{head,diggit-method}
\alias{head.diggit}
\alias{mindyFiltering}
\alias{mindyFiltering,diggit-method}
\alias{print,diggit-method}
\alias{print.diggit}
\alias{show,diggit-method}
\alias{show.diggit}
\alias{summary,diggit-method}
\alias{summary.diggit}
\title{Basic methods for class diggit}
\usage{
\S4method{print}{diggit}(x, pval = 0.05)

\S4method{show}{diggit}(object)

\S4method{exprs}{diggit}(object)

\S4method{diggitCNV}{diggit}(x)

\S4method{diggitRegulon}{diggit}(x)

\S4method{diggitMindy}{diggit}(x)

\S4method{diggitFcnv}{diggit}(x)

\S4method{diggitMR}{diggit}(x)

\S4method{diggitViper}{diggit}(x)

\S4method{diggitAqtl}{diggit}(x)

\S4method{diggitConditional}{diggit}(x)

\S4method{summary}{diggit}(object)

\S4method{head}{diggit}(x, rows = 4, cols = 4)

\S4method{mindyFiltering}{diggit}(x, mr = 0.01, mr.adjust = c("none", "fdr",
  "bonferroni"))
}
\arguments{
\item{x}{Object of class diggit}

\item{pval}{P-value threshold for the conditional analysis}

\item{object}{Object of class diggit}

\item{rows}{Integer indicating the maximum number of rows to show}

\item{cols}{Integer indicating the maximum number of columns to show}

\item{mr}{Either a numerical value between 0 and 1 indicating the p-value threshold for the Master Regulator (MR) selection, or a vector of character strings listing the MRs}

\item{mr.adjust}{Character string indicating the multiple hypothesis test correction for the MRs}
}
\value{
print returns summary information about the diggit object

show returns summary information about the object of class diggit

exprs returns the ExpressionSet object containing the expression profile data

diggitCNV returns a matrix containing the CNV data

diggitRegulon returns a regulon object containing the transcriptional interactome

diggitMindy returns a regulon object containing the post-translational interactome

diggitFcnv returns a vector of p-values for the F-CNVs

diggitMR returns a vector of master regulators NES

diggitViper returns a matrix of VIPER results

diggitAqtl returns a matrix of aQTLs (p-value)

diggitConditional returns a list containing the conditional analysis results

summary returns the integrated results from the conditional analysis

head returns a list containing a reduced view for an object of class diggit

mindyFiltering returns a diggit class object with CNV and aQTL slots filtered to contain only MINDy post-translational modulators of the MRs
}
\description{
This document lists a series of basic methods for the class diggit
}
\examples{
data(gbm.expression, package="diggitdata")
data(gbm.cnv, package="diggitdata")
data(gbm.aracne, package="diggitdata")
dobj <- diggitClass(expset=gbmExprs, cnv=gbmCNV, regulon=gbmTFregulon)
print(dobj)
show(dobj)
exprs(dobj)
diggitCNV(dobj)[1:3, 1:3]
diggitRegulon(dobj)
diggitMindy(dobj)
diggitFcnv(dobj)
diggitMR(dobj)
diggitViper(dobj)
diggitAqtl(dobj)
diggitConditional(dobj)
head(dobj)
data(gbm.expression, package="diggitdata")
data(gbm.cnv, package="diggitdata")
data(gbm.mindy, package="diggitdata")
dobj <- diggitClass(expset=gbmExprs, cnv=gbmCNV, mindy=gbmMindy)
dobj <- fCNV(dobj)
dobj
dobj <- mindyFiltering(dobj, mr=c("STAT3", "CEBPD"))
dobj
}

