% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perf.R
\name{perf}
\alias{perf}
\title{Compare diffusions to a target score on a grid of parameters}
\usage{
perf(
    scores,
    validation,
    grid_param,
    metric = list(auc = metric_fun(curve = "ROC")),
    ...
)
}
\arguments{
\item{scores}{scores to be smoothed; either a named numeric vector,
a column-wise matrix whose rownames are nodes and colnames are
different scores, or a named list of such matrices.}

\item{validation}{target scores to which the smoothed scores
will be compared to. Must have the same format as the input scores,
although the number of rows may vary and only the matching rows will
give a performance measure}

\item{grid_param}{data frame containing parameter combinations to explore.
The column names should be the names of the parameters.}

\item{metric}{named list of metrics to apply. Each metric should accept
the form \code{f(actual, predicted)}}

\item{...}{additional named arguments for the diffusion method.
It's important
to input at least an \code{igraph} object or, alternative, a
kernel matrix \code{K}}
}
\value{
A data frame containing the performance of each diffusion score
}
\description{
Function \code{perf} computes diffusion scores on a grid of
parameters and evaluates them using the gold standard scores
provided by the user.
}
\details{
Function \code{perf} takes a network in
\pkg{igraph} format, an initial state
to score all the nodes in the network, a target score set.
To explore the parameter combinations, it needs a grid and a
list of metrics to apply. The validation scores might be only
a subset of the network nodes, in which case the metric will
be restricted to this set as well.
}
\examples{
# Using a single vector of scores
data(graph_toy)
df_perf <- perf(
    graph = graph_toy,
    scores = graph_toy$input_vec,
    validation = graph_toy$input_vec,
    grid_param = expand.grid(method = c("raw", "ml")))
df_perf
# Using a matrix with four set of scores
# called Single, Row, Small_sample, Large_sample
df_perf <- perf(
    graph = graph_toy,
    scores = graph_toy$input_mat,
    validation = graph_toy$input_mat,
    grid_param = expand.grid(method = c("raw", "ml")))
df_perf

}
