% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffuse_mc.R
\name{diffuse_mc}
\alias{diffuse_mc}
\title{Compute the heatrank using permutations}
\usage{
diffuse_mc(
    graph,
    scores,
    n.perm = 10000,
    sample.prob = NULL,
    seed = 1,
    oneminusHeatRank = TRUE,
    K = NULL,
    ...
)
}
\arguments{
\item{graph}{igraph object}

\item{scores}{Recursive list, can have either binary or quantitative
scores}

\item{n.perm}{Numeric, number of permutations}

\item{sample.prob}{Numeric, probabilities (needn't be scaled) to permute the
input. This is passed to \code{\link[base]{sample}}'s \code{prob} argument.
If \code{NULL}, sampling is uniform. It has to be in a list format,
with the same names as \code{scores}, and each element of the list
must be the sampling probability of each background.}

\item{seed}{Numeric, seed for random number generator}

\item{oneminusHeatRank}{Logical, should \code{1 - heatrank}
be returned instead of \code{heatrank}?}

\item{K}{Kernel matrix (if precomputed). If \code{K} is not supplied,
the regularised Laplacian will be computed on the fly and used.}

\item{...}{currently ignored arguments}
}
\value{
A list containing matrices of heatrank scores
}
\description{
Function \code{diffuse_mc} has an implemented parallelisation of the
Monte Carlo trials for diffusion in a network.
The input scores are assumed to be sparse and are 
internally sparsified, so very dense scores 
migth take time with current implementation.
}
\examples{
# Using a list as input (needed)
data(graph_toy)
list_input <- list(myInput1 = graph_toy$input_mat)
diff_mc <- diffuse_mc(
    graph = graph_toy,
    scores = list_input)

}
