% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\docType{data}
\name{.check_scores}
\alias{.check_scores}
\alias{.available_methods}
\alias{.check_method}
\alias{.check_metric}
\alias{.check_graph}
\alias{.check_K}
\title{Sanity checks for input}
\format{
An object of class \code{character} of length 7.
}
\usage{
.check_scores(scores)

.available_methods

.check_method(method)

.check_metric(metric)

.check_graph(graph)

.check_K(K)
}
\arguments{
\item{scores}{scores to check}

\item{method}{object to test}

\item{metric}{object to test}

\item{graph}{object to test}

\item{K}{object to test}
}
\value{
Functions return \code{invisible()} but throw
warnings and errors as side effect
}
\description{
.check_scores ensures that scores are suitable for diffusion

.available_methods is a character vector with the implemented scores

.check_method ensures that 'method' is a valid character

.check_metric ensures that 'metric' is a valid list of metric functions

.check_graph ensures that 'graph' is a valid \code{igraph} object

.check_K ensures that 'K' is a formally valid kernel.
Does not check for spd
}
\examples{
data(graph_toy)
diffuStats:::.check_scores(diffuStats:::to_list(graph_toy$input_mat))
diffuStats:::.check_method("raw")
diffuStats:::.check_metric(list(auc = metric_fun(curve = "ROC")))
data(graph_toy)
diffuStats:::.check_graph(graph_toy)
data(graph_toy)
diffuStats:::.check_K(regularisedLaplacianKernel(graph_toy))
}
\keyword{datasets}
