% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ParallelHeatrank}
\alias{ParallelHeatrank}
\title{Compute heatrank in parallel}
\usage{
ParallelHeatrank(R, perm, G)
}
\arguments{
\item{R}{dense matrix with the diffusion kernel}

\item{perm}{dense matrix with the permutations (indices in columns).
This has to ensure that enough indices are sampled, i.e. at least as
great as the largest list in the input (largest \code{colSums} in G)}

\item{G}{S4 sparse matrix with the heat sources}
}
\value{
a matrix with the same amount of rows that \code{R}
and columns in \code{G}, containing the heatrank scores. These scores
are corrected using \code{(r + 1)/(p + 1)}
instead of \code{r/p}. The smaller the score, the
warmer the node.
}
\description{
\code{ParallelHeatrank} is a wrapper that computes heatranks for (possibly)
different backgrounds and for multiple inputs at once. It will
reuse the permutations, which have to be passed to the function.
The input must be binary for this implementation, so numeric values for
each node are not supported.
}
