# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' S4 sparse matrix to arma::sp_mat
#'
#' Convert an S4 sparse matrix from the \code{\link[Matrix]{Matrix}} package
#' to an arma \code{sp_mat}.
#'
#' @source \url{http://gallery.rcpp.org/articles/armadillo-sparse-matrix/}
#'
#' @param mat S4 sparse matrix from the \code{\link[Matrix]{Matrix}}
#'
#' @return an arma::sp_mat object
convertSparse <- function(mat) {
    .Call(diffuStats_convertSparse, mat)
}

#' Sparsify arma::mat into arma::sp_mat
#'
#' Return permutations as a numeric sparse matrix
#' (can be binary or continuous)
#'
#' @param perm dense matrix with the permutations
#' @param nrow number of rows for the sparse matrix
#' @param G sparse column matrix
#'
#' @return an arma::sp_mat object
sparsify2 <- function(perm, nrow, G) {
    .Call(diffuStats_sparsify2, perm, nrow, G)
}

#' Compute heatrank for a single case
#'
#' The heatrank incorporates the correction \code{(r + 1)/(p + 1)}
#' instead of \code{r/p}
#'
#' @param R dense matrix with the diffusion kernel
#' @param perm sparse matrix with the permutations
#' @param G sparse matrix with the heat sources
#' @param ind index of the G column for current source
#'
#' @return an arma::vec with node heatranks
serialHeatrank <- function(R, perm, G, ind) {
    .Call(diffuStats_serialHeatrank, R, perm, G, ind)
}

#' Compute heatrank in parallel
#'
#' \code{ParallelHeatrank} is a wrapper that computes heatranks for (possibly)
#' different backgrounds and for multiple inputs at once. It will
#' reuse the permutations, which have to be passed to the function.
#' The input must be binary for this implementation, so numeric values for
#' each node are not supported.
#'
#' @param R dense matrix with the diffusion kernel
#' @param perm dense matrix with the permutations (indices in columns).
#' This has to ensure that enough indices are sampled, i.e. at least as
#' great as the largest list in the input (largest \code{colSums} in G)
#' @param G S4 sparse matrix with the heat sources
#'
#' @return a matrix with the same amount of rows that \code{R}
#' and columns in \code{G}, containing the heatrank scores. These scores
#' are corrected using \code{(r + 1)/(p + 1)}
#' instead of \code{r/p}. The smaller the score, the
#' warmer the node.
#'
ParallelHeatrank <- function(R, perm, G) {
    .Call(diffuStats_ParallelHeatrank, R, perm, G)
}

