% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coexpr.R
\name{coexpr}
\alias{coexpr}
\title{Identification of gene pairs coexpressed in at least one of two conditions}
\usage{
coexpr(exprs.1, exprs.2, r.method = c("pearson", "spearman")[1],
  q.method = c("BH", "holm", "hochberg", "hommel", "bonferroni", "BY", "fdr",
  "none")[1], rth = 0.5, qth = 0.1)
}
\arguments{
\item{exprs.1}{a SummarizedExperiment, data frame or matrix for condition 1, with gene IDs as rownames and sample IDs as column names.}
\item{exprs.2}{a SummarizedExperiment, data frame or matrix for condition 2, with gene IDs as rownames and sample IDs as column names.}
\item{r.method}{a character string specifying the method to be used to calculate correlation coefficients. It is passed to the cor function of the WGCNA package.}
\item{q.method}{a character string specifying the method for adjusting p values. It is passed to the p.adjust function of the stats package.}
\item{rth}{the cutoff of absolute value of correlation coefficients; must be within [0,1].}
\item{qth}{the cutoff of q-value (adjusted p value); must be within [0,1].}
}
\value{
a data frame containing gene pairs that are coexpressed in at least one of the conditions with the criteria that absolute value of correlation coefficient is greater than rth and q value less than qth. It has the following columns:
  \item{\code{Gene.1}}{Gene ID}
  \item{\code{Gene.2}}{Gene ID}
  \item{\code{cor.1}}{correlation coefficients under condition 1}
  \item{\code{cor.2}}{correlation coefficients under condition 2}
  \item{\code{cor.diff}}{difference between correlation coefficients under condition 2 and condition 1}
  \item{\code{p.1}}{p value under null hypothesis that correlation coefficient under condition 1 equals to zero}
  \item{\code{p.2}}{p value under null hypothesis that correlation coefficient under condition 2 equals to zero}
  \item{\code{p.diffcor}}{p value under null hypothesis that difference between two correlation coefficients under two conditions equals to zero using Fisher's r-to-Z transformation}
  \item{\code{q.1}}{adjusted p value under null hypothesis that correlation coefficient under condition 1 equals to zero}
  \item{\code{q.2}}{adjusted p value under null hypothesis that correlation coefficient under condition 2 equals to zero}
  \item{\code{q.diffcor}}{adjusted p value under null hypothesis that the difference between two correlation coefficients under two conditions equals to zero using Fisher's r-to-Z transformation}
}
\description{
This function identifies gene pairs coexpressed in at least one of two conditions.
}
\examples{
data(gse4158part)
allowWGCNAThreads()
res=coexpr(exprs.1 = exprs.1, exprs.2 = exprs.2, r.method = "spearman")
#The result is a data frames.
str(res)
}
\keyword{coexpression}
