% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{geneBinHeatmap}
\alias{geneBinHeatmap}
\title{geneBinHeatmap}
\usage{
geneBinHeatmap(
  se,
  gene,
  what = NULL,
  anno_rows = c("type", "logWidth", "meanLogDensity", "log10PValue", "geneAmbiguous"),
  anno_columns = c(),
  anno_colors = list(),
  removeAmbiguous = FALSE,
  merge_legends = TRUE,
  cluster_columns = FALSE,
  minDensityRatio = 0.1,
  left_annotation = NULL,
  top_annotation = NULL,
  ...
)
}
\arguments{
\item{se}{A bin-wise SummarizedExperiment as produced by
\code{\link{countFeatures}}}

\item{gene}{The gene of interest}

\item{what}{Type of values (i.e. assay) to plot}

\item{anno_rows}{Row annotation columns (i.e. columns of `rowData(se)`) to
plot}

\item{anno_columns}{Column annotation columns (i.e. columns of
`colData(se)`) to plot}

\item{anno_colors}{Annotation colors, as a list named with the row/column
annotations, see `\code{\link[ComplexHeatmap]{SingleAnnotation}}` for
details. Ignored if `left_annotation` and/or `top_annotation` are given
directly.}

\item{removeAmbiguous}{Logical; whether to remove bins that are
gene-ambiguous (i.e. overlap multiple genes).}

\item{merge_legends}{Logical; whether to merge legends. This effectively
calls `draw(..., merge_legends=TRUE)` around the heatmap.}

\item{cluster_columns}{Logical; whether to cluster columns (passed to
\code{\link[ComplexHeatmap]{Heatmap}})}

\item{minDensityRatio}{Minimum ratio of read density (with respect to the 
gene's average) for a bin to be plotted.}

\item{left_annotation}{Passed to \code{\link[ComplexHeatmap]{Heatmap}},
overrides `anno_rows`.}

\item{top_annotation}{Passed to \code{\link[ComplexHeatmap]{Heatmap}},
overrides `anno_columns`.}

\item{...}{Passed to `ComplexHeatmap` (see
\code{\link[ComplexHeatmap]{Heatmap}})}
}
\value{
A \code{\link[ComplexHeatmap]{Heatmap}}
}
\description{
A wrapper around `ComplexHeatmap`.
}
\examples{
data(example_bin_se)
se <- diffSpliceWrapper(example_bin_se, ~condition)
geneBinHeatmap(se, "Jund")
}
