% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_vcf.R
\name{subset_vcf}
\alias{subset_vcf}
\title{Subset common variants vcf file to only SNPs seen in 'top_genes'}
\usage{
subset_vcf(vcf, top_genes, ensdb)
}
\arguments{
\item{vcf}{object of class CollapsedVCF}

\item{top_genes}{output from 'common_genes' function, alternatively character vector containing custom gene names.}

\item{ensdb}{object of class EnsDb corresponding to organism, genome of data}
}
\value{
object of class CollapsedVCF containing subset of SNPs from supplied vcf seen in commonly expressed genes
}
\description{
Subset common variants vcf file to only SNPs seen in 'top_genes'
}
\examples{
data(multiplexed_scrnaseq_sce, commonvariants_1kgenomes_subset)
top_genes <- common_genes(multiplexed_scrnaseq_sce)
ensdb <- EnsDb.Hsapiens.v86::EnsDb.Hsapiens.v86
small_vcf <- subset_vcf(commonvariants_1kgenomes_subset, top_genes, ensdb)

}
