% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reassign_centroid.R
\name{reassign_centroid}
\alias{reassign_centroid}
\title{Reassign cells based on SNPs}
\usage{
reassign_centroid(
  sce,
  train_cells = sce$train,
  predict_cells = sce$predict,
  labels = sce$labels,
  min_cells = 30,
  key = "Hashtag"
)
}
\arguments{
\item{sce}{SingleCellExperiment object}

\item{train_cells}{logical, cells to be used for training}

\item{predict_cells}{logical, cells to be used for prediction}

\item{labels}{provisional cell labels}

\item{min_cells}{minimum coverage (number of cells with read at SNP location) for SNP to be used for classification.}

\item{key}{unique key in naming of singlet groups used with grep to remove doublet/negative/uncertain labels}
}
\value{
character vector containing reassignments
}
\description{
Reassign cells based on SNPs
}
\examples{
data(multiplexed_scrnaseq_sce, vartrix_consensus_snps)
multiplexed_scrnaseq_sce <- high_conf_calls(multiplexed_scrnaseq_sce)
multiplexed_scrnaseq_sce <- add_snps(sce = multiplexed_scrnaseq_sce, 
mat = vartrix_consensus_snps, 
thresh = 0.8)
multiplexed_scrnaseq_sce<-reassign_centroid(multiplexed_scrnaseq_sce)
}
