% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reassign_balanced.R
\name{reassign_balanced}
\alias{reassign_balanced}
\title{Reassign cells using balanced knn with jaccard distance}
\usage{
reassign_balanced(
  sce,
  k = 20,
  d_prop = 0.5,
  train_cells = sce$train,
  predict_cells = sce$predict,
  nmin = 50,
  n = NULL
)
}
\arguments{
\item{sce}{object of class SingleCellExperiment}

\item{k}{number of neighbours used in knn, defaults to 10}

\item{d_prop}{determines number of doublets simulatted d, as a proportions of n (specified or calculated)}

\item{train_cells}{logical vector specifying which cells to use to train
classifier}

\item{predict_cells}{logical vector specifying which cells to classify}

\item{nmin}{min n per class (where available)}

\item{n}{number of cells per group (otherwise will be calculated from data)}
}
\value{
A SingleCellExperiment with updated group assignments called 'knn_balanced'
}
\description{
k-nearest neighbour classification of cells.
Training data is intended to be labels of cells confidently called using
cell hashing based methods and their corresponding SNPs.
Prediction data can be remaining cells but can also include the training
data.
Doublets are simulated by randomly combining 'd' SNP profiles from each
grouping combination.
}
\examples{
data(multiplexed_scrnaseq_sce, vartrix_consensus_snps)
multiplexed_scrnaseq_sce <- high_conf_calls(multiplexed_scrnaseq_sce)
multiplexed_scrnaseq_sce <- add_snps(sce = multiplexed_scrnaseq_sce, 
mat = vartrix_consensus_snps, 
thresh = 0.8)
multiplexed_scrnaseq_sce <- reassign_balanced(sce = multiplexed_scrnaseq_sce, k = 10, d=0.5)

}
