% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deltaCaptureC.R
\name{getRunTotals}
\alias{getRunTotals}
\title{Get the runs and their values}
\usage{
getRunTotals(se, innerRegion, colName = "delta")
}
\arguments{
\item{se}{a SummarizedExperiment whose first assay has a column named
colName. Typically this will be a one-column matrix with delta.}

\item{innerRegion}{a Granges object defining the region surrounding
the viewpoint to be excluded from run total calculations}

\item{colName}{defaults to 'delta'}
}
\value{
a GRanges object giving the contiguous regions and their
respective sums
}
\description{
This function finds the runs of consecutive ranges in which the
sign of the data does not change.  It returns a GRanges object
containing the contiguous ranges and the weighted sum of  data in
each.
}
\examples{
runTotals = getRunTotals(binnedDeltaSE,viewpointRegion)
}
