% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/celda_functions.R
\name{retrieveFeatureIndex}
\alias{retrieveFeatureIndex}
\title{Retrieve row index for a set of features}
\usage{
retrieveFeatureIndex(
  features,
  x,
  by = "rownames",
  exactMatch = TRUE,
  removeNA = FALSE
)
}
\arguments{
\item{features}{Character vector of feature names to find in the rows of
\code{x}.}

\item{x}{A data.frame, matrix, or \linkS4class{SingleCellExperiment}
object to search.}

\item{by}{Character. Where to search for features in \code{x}. If set to
\code{"rownames"} then the features will be searched for among
\code{rownames(x)}. If \code{x} inherits from class
\linkS4class{SummarizedExperiment}, then \code{by} can be one of the
fields in the row annotation data.frame (i.e. one of
\code{colnames(rowData(x))}).}

\item{exactMatch}{Boolean. Whether to only identify exact matches
or to identify partial matches using \code{\link{grep}}.}

\item{removeNA}{Boolean. If set to \code{FALSE}, features not found in
\code{x} will be given \code{NA} and the returned vector will be the same
length as \code{features}. If set to \code{TRUE}, then the \code{NA}
values will be removed from the returned vector. Default \code{FALSE}.}
}
\value{
A vector of row indices for the matching features in \code{x}.
}
\description{
This will return indices of features among the rownames
or rowData of a data.frame, matrix, or a \linkS4class{SummarizedExperiment}
object including a \linkS4class{SingleCellExperiment}.
Partial matching (i.e. grepping) can be used by setting
\code{exactMatch = FALSE}.
}
\examples{
counts <- matrix(sample(1:10, 20*10, replace = TRUE),
                 nrow = 20, ncol = 10,
                 dimnames = list(paste0("Gene_",1:20),
                                 paste0("Cell_", 1:10)))
retrieveFeatureIndex(c("Gene_1", "Gene_5"), counts)
retrieveFeatureIndex(c("Gene_1", "Gene_5"), counts, exactMatch = FALSE)
}
\seealso{
'\link[scater]{retrieveFeatureInfo}' from package \code{'scater'}
and \code{link{regex}} for how to use regular expressions when
\code{exactMatch = FALSE}.
}
\author{
Yusuke Koga, Joshua Campbell
}
