% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions_for_class_checks.R
\name{isAlexandrovSet}
\alias{isAlexandrovSet}
\title{isAlexandrovSet}
\usage{
isAlexandrovSet(x)
}
\arguments{
\item{x}{Object to be checked.}
}
\value{
Logical value (true or false).
}
\description{
`isAlexandrovSet()` checks whether the input object is a set (list) of
numeric objects compatible with the Alexandrov format (probability vectors;
sum up to 1). NOTE: These can also be genomes compatible with the
Alexandrov format!
}
\examples{

### get Alexandrov signatures from COSMIC
signAlexandrov <- readAlexandrovSignatures()

isAlexandrovSet(signAlexandrov)
}
\references{
\url{http://rmpiro.net/decompTumor2Sig/}\cr
Krueger, Piro (2019) decompTumor2Sig: Identification of mutational
signatures active in individual tumors. BMC Bioinformatics
20(Suppl 4):152.\cr
}
\seealso{
\code{\link{decompTumor2Sig}}\cr
\code{\link{readAlexandrovSignatures}}\cr
\code{\link{isSignatureSet}}
}
\author{
Rosario M. Piro\cr Politecnico di Milano\cr Maintainer: Rosario
M. Piro\cr E-Mail: <rmpiro@gmail.com> or <rosariomichael.piro@polimi.it>
}
