% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplexplot.R
\name{simplexplot}
\alias{simplexplot}
\title{The plot of scatter simplex}
\usage{
simplexplot(data, A, MGlist = NULL, data.extra = NULL,
  corner.order = NULL, col = "gray", pch = 1, cex = 0.8,
  mg.col = "red", mg.pch = 1, mg.cex = 1.2, ex.col = "black",
  ex.pch = 19, ex.cex = 1.5, ...)
}
\arguments{
\item{data}{A data set that will be internally coerced into a matrix.
Each row is a gene and each column is a sample.
Data should be in non-log linear space with non-negative numerical values
(i.e. >= 0). Missing values are not supported.
All-zero rows will be removed internally.}

\item{A}{Prior/Estimated proportion matrix.}

\item{MGlist}{A list of vectors, each of which contains known markers
and/or CAM-detected markers for one subpopulation.}

\item{data.extra}{Extra data points to be shown in the simplex plot, e.g.
the points associated with prior/estimated proportion vectors. The format
should be consistent with \code{data}, so prior/estimated proportion
matrix needs to be transposed before as the input.}

\item{corner.order}{The order to show simplex corners counterclockwise.}

\item{col}{The color for data points. The default is "gray".}

\item{pch}{The symbol/character for data points. The default is 1.}

\item{cex}{The symbol/character expansion for data points.
The default is 0.8.}

\item{mg.col}{The colors for marker genes. Marker genes of one subpopulation
could have their own color if a vector is provided. The default is "red".}

\item{mg.pch}{The symbols/characters for marker genes. Marker genes of one
subpopulation could have their own symbol/character if a vector is
provided. The default is 1.}

\item{mg.cex}{The symbol/character expansion for marker genes.
The default is 1.2.}

\item{ex.col}{The colors for extra data points. Each data point could have
its own color if a vector is provided. The default is "black".}

\item{ex.pch}{The symbols/characters for extra data points. Each data point
could have its own symbol/character if a vector is provided.
The default is 19.}

\item{ex.cex}{The symbol/character expansion for extra data points.
The default is 1.5.}

\item{...}{All other arguments are passed to the plotting command.}
}
\value{
A plot to the current device.
}
\description{
This function shows scatter simplex of mixture expressions.
}
\details{
This function can show the scatter simplex and detected marker genes
in a 2D plot. The corners in the high-dimensional simplex will still locate
at extreme points of low-dimensional simplex. These corners will follow the
order set by \code{corner.order} to display in the plot counterclockwise.
}
\examples{
#obtain data, A matrix, marker genes
data(ratMix3)
data <- ratMix3$X
A <- ratMix3$A
pMGstat <- MGstatistic(ratMix3$S, c("Liver","Brain","Lung"))
pMGlist.FC <- lapply(c("Liver","Brain","Lung"), function(x)
    rownames(pMGstat)[pMGstat$idx == x & pMGstat$OVE.FC > 10])

#plot simplex for data
simplexplot(data, A)
simplexplot(data, A, MGlist = pMGlist.FC) #Color marker genes in the plot
simplexplot(data, A, MGlist = pMGlist.FC,
    data.extra = t(A)) #show the location of proportion vectors in the plot

#set different corner order and colors
simplexplot(data, A, MGlist = pMGlist.FC, corner.order = c(2,1,3),
            col = "blue", mg.col = c("red","orange","green"))
}
