% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reselectMG.R
\name{reselectMG}
\alias{reselectMG}
\title{Reselect markers by thresholding}
\usage{
reselectMG(data, MGlist, fc.thres = "q0.5", err.thres = NULL)
}
\arguments{
\item{data}{A data set that will be internally coerced into a matrix.
Each row is a gene and each column is a sample.
data should be in non-log linear space with non-negative numerical values
(i.e. >= 0).
Missing values are not supported.
All-zero rows will be removed internally.}

\item{MGlist}{A list of vectors, each of which contains CAM-detected markers
and/or prior markers for one subpopulation.}

\item{fc.thres}{The lower threshold of fold change to select markers,
an absolute value (e.g. 10) or a quantile value after 'q' (e.g. 'q0.5',
the median of fold changes of one subpopulation's input markers).
Each subpopulation can have its own threshold if a vector is provided.
The default is 'q0.5'. If NULL, still use the input markers.}

\item{err.thres}{The upper threshold of reconstruction error to select
markers, an absolute value or a quantile value after 'q' (e.g. 'q0.5',
the median of reconstruction errors of one subpopulation's input markers;
'q1.2', the maximum error times 1.2 ).
Each subpopulation can have its own threshold if a vector is provided.
The default is NULL, which means no such a threshold is applied.}
}
\value{
A list of vectors, each of which contains new selected markers
    for one subpopulation.
}
\description{
This function generates a new list of markers based on initially detected
markers by CAM and/or prior markers.
}
\details{
Considering some meaningful markers may be mistakenly filtered by
preprocessing and thus missed by \code{\link{CAM}}, this function use the
input marker gene list to estimate proportions by \code{\link{AfromMarkers}}
and then estimate expression levels. Next, a new list of markers are
generated by fold change threshold and reconstruction error threshold.

The input marker genes could also be from other supervised detection and/or
from literatures. This function reselects a list of marker genes
based on the input.
}
\examples{
#obtain data and run CAM
data(ratMix3)
data <- ratMix3$X
rCAM <- CAM(data, K = 3, dim.rdc= 3, thres.low = 0.30, thres.high = 0.95)
#obtain marker genes detected by CAM with a fixed K
MGlist <- MGsforA(rCAM, K = 3)
#Reselect markers from all genes
MGlist.re <- reselectMG(data, MGlist, fc.thres='q0.5')
MGlist.re <- reselectMG(data, MGlist, fc.thres='q0.5', err.thres='q0.95')
}
