% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redoASest.R
\name{redoASest}
\alias{redoASest}
\title{Re-estimate A, S matrix}
\usage{
redoASest(data, MGlist, A = NULL, S = NULL, generalNMF = FALSE,
  maxIter = 2, methy = FALSE)
}
\arguments{
\item{data}{A data set that will be internally coerced into a matrix.
Each row is a gene and each column is a sample.
data should be in non-log linear space with non-negative numerical values
(i.e. >= 0).
Missing values are not supported.
All-zero rows will be removed internally.}

\item{MGlist}{A list of vectors, each of which contains CAM-detected markers
and/or prior markers for one subpopulation.}

\item{A}{Initial proportion matrix. If NULL, it will be estimated from
initial expression matrix. If initial expression matrix is also NULL, it
will be estimated from \code{MGlist} using \code{\link{AfromMarkers}}.}

\item{S}{Initial expression matrix. If NULL, it will be estimated from
initial proportion matrix.}

\item{generalNMF}{If TRUE, the decomposed proportion matrix has no sum-to-one
constraint for each row. Without this constraint, the scale ambiguity of
each column vector in proportion matrix will not be removed.
The default is FALSE.}

\item{maxIter}{maximum number of iterations for Alternating Least
Square (ALS) method. The default is 2. If zero, ALS is not applied.}

\item{methy}{Should be TRUE when dealing with methylation data, whose
expression levels are confined between 0 and 1.}
}
\value{
A list containing the following components:
\item{Aest}{Proportion matrix after re-estimation and possible refinement.}
\item{Sest}{expression matrix after re-estimation and possible refinement.}
\item{mse}{Mean squared error (i.e. mean of reconstruction errors)
for input markers}
}
\description{
This function re-estimates proportion and expression matrix iteratively
by Alternating Least Square (ALS) method. The initial values are from
markers or known proportion matrix or known expression matrix,
}
\details{
If only markers are provided, they are used to estimate initial
proportion matrix and then expression matrix. If proportion matrix or
expression matrix is provided, it will be treated as initial matrix to
estimate the other one. Then Alternating Least Square (ALS) method is
applied to estimate two matrix alternatively. Note only markers'
squared errors will be counted in ALS, which facilitates (1) faster
computational running time and (2) a greater signal-to-noise ratio owing to
markers' discriminatory power.

This function can be used to refine CAM estimation or perform supervised
deconvolution. Note that allowing too many iterations may bring the risk of
a significant deviation from initial values.
}
\examples{
#obtain data and run CAM
data(ratMix3)
data <- ratMix3$X
rCAM <- CAM(data, K = 3, dim.rdc= 3, thres.low = 0.30, thres.high = 0.95)
#obtain marker genes detected by CAM for estimating A
MGlist <- MGsforA(rCAM, K = 3)

#Re-estimation based on marker list
rre <- redoASest(data, MGlist, maxIter = 10)
Aest <- rre$Aest #re-estimated A matrix
Sest <- rre$Sest #re-estimated S matrix

#Re-estimation with initial A matrix
rre <- redoASest(data, MGlist, A=ratMix3$A, maxIter = 10)

#Re-estimation with initial S matrix
rre <- redoASest(data, MGlist, S=ratMix3$S, maxIter = 10)
}
