% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XWProj.R
\name{XWProj}
\alias{XWProj}
\title{Perspective projection to obtain simplex}
\usage{
XWProj(data, W)
}
\arguments{
\item{data}{A data set that will be internally coerced into a matrix.
Each row is a gene and each column is a sample. Missing values
are not supported.
All-zero rows will be removed internally.}

\item{W}{The matrix whose rows are loading vectors;
should be obtained from \code{\link{CAM}}/\code{\link{CAMPrep}} function
with accessor method \code{\link{PCAmat}}.}
}
\value{
The data after perspective projection.
}
\description{
This function reduces data dimension by loading matrix and then project
dimension-reduced data to the hyperplane orthogonal to c(1,0,...,0),
i.e., the first axis in the new coordinate system..
}
\details{
This function can project gene expression vectors to simplex plot
generated by \code{\link{CAM}}/\code{\link{CAMPrep}}. Using slot \code{Xproj}
in "\code{\link{CAMPrepObj}}" can only show the simplex of genes after
filtering. This function helps observe all genes in simplex plot.
}
\examples{
#obtain data
data(ratMix3)
data <- ratMix3$X

#preprocess data
rPrep <- CAMPrep(data, dim.rdc = 3, thres.low = 0.50, thres.high = 0.90)

#obtain simplex
Xproj <- XWProj(data, PCAmat(rPrep))
#plot simplex in 3d space
#plot3d(Xproj[,-1]) #The first dimension is constant after projection
}
