% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\docType{methods}
\name{PCAmat}
\alias{PCAmat}
\alias{PCAmat,CAMObj-method}
\alias{PCAmat,CAMPrepObj-method}
\title{Dimension-reduction loading matrix accessor}
\usage{
PCAmat(x, ...)

\S4method{PCAmat}{CAMObj}(x)

\S4method{PCAmat}{CAMPrepObj}(x)
}
\arguments{
\item{x}{a \code{\link{CAMObj}} object or a \code{\link{CAMPrepObj}} object}

\item{...}{additional argument list.}
}
\value{
The matrix whose rows are loading vectors for dimension reduction.
}
\description{
Accessor to Dimension-reduction loading matrix.
}
\examples{
#obtain data
data(ratMix3)
data <- ratMix3$X

rCAM <- CAM(data, K = 3, dim.rdc = 3, thres.low = 0.30, thres.high = 0.95)
W <- PCAmat(rCAM)
W <- PCAmat(slot(rCAM, "PrepResult"))
}
