% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGstatistic.R
\name{MGstatistic}
\alias{MGstatistic}
\title{Statistics for ranking marker genes}
\usage{
MGstatistic(data, A = NULL, boot.alpha = NULL, nboot = 1000,
  cores = NULL)
}
\arguments{
\item{data}{A data set that will be internally coerced into a matrix.
Each row is a gene and each column is a sample.
Data should be in non-log linear space with non-negative numerical values
(i.e. >= 0). Missing values are not supported.
All-zero rows will be removed internally.}

\item{A}{When data are mixture expression profiles,
A is estimated proportion matrix or prior proportion matrix.
When data are pure expression profiles, A is a phenotype vector to
indicate which subpopulation each sample belongs to.}

\item{boot.alpha}{Alpha for bootstrapped OVE-FC confidence interval.
The default is 0.05.}

\item{nboot}{The number of boots.}

\item{cores}{The number of system cores for parallel computing.
If not provided, the default back-end is used.}
}
\value{
A data frame containing the following components:
\item{idx}{Numbers or phenotypes indicating which subpopulation each gene
could be a marker for. If A is a proportion matrix without column name,
numbers are returned. Otherwise, phenotypes.}
\item{OVE.FC}{One-versus-Everyone fold change (OVE-FC)}
\item{OVE.FC.alpha}{lower confidence bound of bootstrapped OVE-FC at alpha
    level.}
}
\description{
This function computes One-Versus-Everyone Fold Change (OVE-FC)
from subpopulation-specific expression profiles.
Bootstrapping is optional.
}
\details{
This function calculates OVE-FC and bootstrapped OVE-FC which can be
used to identify markers from all genes.
}
\examples{
#data are mixture expression profiles, A is proportion matrix
data(ratMix3)
MGstat <- MGstatistic(ratMix3$X, ratMix3$A)
\dontrun{
MGstat <- MGstatistic(ratMix3$X, ratMix3$A, boot.alpha = 0.05) #enable boot
}

#data are pure expression profiles without replicates
MGstat <- MGstatistic(ratMix3$S) #boot is not applicable
\dontrun{
#data are pure expression profiles with phenotypes
S <- matrix(rgamma(3000,0.1,0.1), 1000, 3)
S <- S[, c(1,1,1,2,2,2,3,3,3,3)] + rnorm(1000*10, 0, 0.5)
MGstat <- MGstatistic(S, c(1,1,1,2,2,2,3,3,3,3), boot.alpha = 0.05)
}
}
