% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGsforA.R
\name{MGsforA}
\alias{MGsforA}
\title{Marker genes detected by CAM for estimating A}
\usage{
MGsforA(CAMResult = NULL, K = NULL, PrepResult = NULL,
  MGResult = NULL, corner.strategy = 2)
}
\arguments{
\item{CAMResult}{Result from \code{\link{CAM}}.}

\item{K}{The candidate subpopulation number.}

\item{PrepResult}{An object of class "CAMPrepObj" from \code{\link{CAMPrep}}.}

\item{MGResult}{An object of class "CAMMGObj" from
\code{\link{CAMMGCluster}}.}

\item{corner.strategy}{The method to detect corner clusters.
1: minimum sum of margin-of-errors; 2: minimum sum of reconstruction
errors. The default is 2.}
}
\value{
A list of vectors, each of which contains marker genes for one
subpopulation.
}
\description{
This function returns marker genes detected by CAM for estimating A.
}
\details{
This function needs to specify CAMResult and K, or PrepResult and
MGResult. The returned marker genes are those used by CAM for estimating A.
To obtain a more complete marker gene list, please refer to
\code{\link{MGstatistic}}.
}
\examples{
#obtain data and run CAM
data(ratMix3)
data <- ratMix3$X
rCAM <- CAM(data, K = 3, dim.rdc= 3, thres.low = 0.30, thres.high = 0.95)
#obtain marker genes detected by CAM for estimating A
MGlist <- MGsforA(rCAM, K = 3)

#obtain data and run CAM step by step
rPrep <- CAMPrep(data, dim.rdc= 3, thres.low = 0.30, thres.high = 0.95)
rMGC <- CAMMGCluster(3, rPrep)
#obtain marker genes detected by CAM for estimating A
MGlist <- MGsforA(PrepResult = rPrep, MGResult = rMGC)
}
