% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CAMMGCluster.R
\name{CAMMGCluster}
\alias{CAMMGCluster}
\title{MG cluster detection for CAM}
\usage{
CAMMGCluster(K, PrepResult, generalNMF = FALSE, nComb = 200)
}
\arguments{
\item{K}{The candidate subpopulation number.}

\item{PrepResult}{An object of class "\code{\link{CAMPrepObj}}" obtained
from \code{\link{CAMPrep}} function.}

\item{generalNMF}{If TRUE, the decomposed proportion matrix has no sum-to-one
constraint for each row. Without this constraint, the scale ambiguity of
corner cluster centers will not be removed when computing
reconstruction errors.
The default is FALSE.}

\item{nComb}{The number of possible combinations of clusters as corner
clusters. Within these possible combinations ranked by margin errors,
we can further select the best one based on reconstruction errors.
The default is 200.}
}
\value{
An object of class "\code{\link{CAMMGObj}}" containing the
following components:
\item{idx}{Two numbers which are two solutions' ranks by sum of
    margin-of-error.}
\item{corner}{The indexes of clusters as detected corners. Each row is a
    solution.}
\item{error}{Two rows. The first row is sum of margin-of-errors for nComb
    possible combinations. The second row is reconstruction errors for
    nComb possible combinations.}
}
\description{
This function finds corner clusters as MG clusters
(clusters containing marker genes).
}
\details{
This function is used internally by \code{\link{CAM}} function to
detect clusters containing marker genes,
or used when you want to perform CAM step by step.

This function provides two solutions. The first is the combination of
clusters yielding the minimum sum of margin-of-errors for cluster centers.
In the second, nComb possible combinations are selected by ranking sum of
margin-of-errors for cluster centers. Then the best one is selected based on
reconstruction errors of all data points in original space.
}
\examples{
#obtain data
data(ratMix3)
data <- ratMix3$X

#preprocess data
rPrep <- CAMPrep(data, dim.rdc = 3, thres.low = 0.30, thres.high = 0.95)

#Marker gene cluster detection with a fixed K = 3
rMGC <- CAMMGCluster(3, rPrep)
}
