% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CAMASest.R
\name{CAMASest}
\alias{CAMASest}
\title{A and S matrix estimation by CAM}
\usage{
CAMASest(MGResult, PrepResult, data, corner.strategy = 2,
  appro3 = TRUE, generalNMF = FALSE)
}
\arguments{
\item{MGResult}{An object of class "\code{\link{CAMMGObj}}" obtained from
\code{\link{CAMMGCluster}} function.}

\item{PrepResult}{An object of class "\code{\link{CAMPrepObj}}" obtained
from \code{\link{CAMPrep}} function.}

\item{data}{Matrix of mixture expression profiles which need to be the same
as the input of \code{\link{CAMPrep}}.
Data frame, SummarizedExperiment or ExpressionSet object will be
internally coerced into a matrix.
Each row is a gene and each column is a sample.
Data should be in non-log linear space with non-negative numerical values
(i.e. >= 0). Missing values are not supported.
All-zero rows will be removed internally.}

\item{corner.strategy}{The method to detect corner clusters.
1: minimum sum of margin-of-errors; 2: minimum sum of reconstruction
errors. The default is 2.}

\item{appro3}{Estimate A and S matrix by approach 3 or not. Please see
details for further information. The default is TRUE.}

\item{generalNMF}{If TRUE, the decomposed proportion matrix has no sum-to-one
constraint for each row. Without this constraint, the scale ambiguity of
each column vector in proportion matrix will not be removed.
The default is FALSE.}
}
\value{
An object of class "\code{\link{CAMASObj}}" containing the
following components:
\item{Aest}{Estimated proportion matrix from Approach 2.}
\item{Sest}{Estimated subpopulation-specific expression matrix from
    Approach 2.}
\item{Aest.proj}{Estimated proportion matrix from Approach 2, before
    removing scale ambiguity.}
\item{Ascale}{The estimated scales to remove scale ambiguity
    of each column vector in Aest. Sum-to-one constraint on each row of
    Aest is used for scale estimation.}
\item{AestO}{Estimated proportion matrix from Approach 3.}
\item{SestO}{Estimated subpopulation-specific expression matrix from
    Approach 3.}
\item{AestO.proj}{Estimated proportion matrix from Approach 3, before
    removing scale ambiguity.}
\item{AscaleO}{The estimated scales to remove scale ambiguity
    of each column vector in AestO. Sum-to-one constraint on each row of
    AestO is used for scale estimation.}
\item{datalength}{Three values for code length of data. The first is
    calculated based on dimension-reduced data. The second and third are
    based on the original data.}
\item{mdl}{Three mdl values. The first is calculated based on
    dimension-reduced data. The second and third are based on the original
    data.}
}
\description{
This function estimates A and S matrix based on marker gene clusters
detected by CAM.
}
\details{
This function is used internally by \code{\link{CAM}} function to
estimate proportion matrix (A), subpopulation-specific expression matrix (S)
and mdl values. It can also be used when you want to perform CAM step by
step.

The mdl values are calculated in three approaches:
(1) based on data and A matrix in dimension-reduced space; (2) based on
original data with A matrix estimated by transforming dimension-reduced
A matrix back to original space;
(3) based on original data with A directly estimated in original space.
A and S matrix in original space estimated from the latter two approaches are
returned. mdl is the sum of two terms: code length of data under the model
and code length of model. Both mdl value and the first term (code length
of data) will be returned.
}
\examples{
#obtain data
data(ratMix3)
data <- ratMix3$X

#preprocess data
rPrep <- CAMPrep(data, dim.rdc = 3, thres.low = 0.30, thres.high = 0.95)

#Marker gene cluster detection with a fixed K
rMGC <- CAMMGCluster(3, rPrep)

#A and S matrix estimation
rASest <- CAMASest(rMGC, rPrep, data)
}
