% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{CAMASObj-class}
\alias{CAMASObj-class}
\alias{CAMASObj}
\title{Class "CAMASObj"}
\description{
An S4 class for storing estimated proportions, subpopulation-specific
expressions and mdl values.
The mdl values are calculated in three approaches:
(1) based on data and A matrix in dimension-reduced space; (2) based on
original data with A matrix estimated by transforming dimension-reduced
A matrix back to original space;
(3) based on original data with A directly estimated in original space.
A and S matrix in original space estimated from the latter two approaches are
returned. mdl is the sum of two terms: code length of data under the model
and code length of model. Both mdl value and the first term (code length
of data) will be returned.
}
\section{Slots}{

\describe{
\item{\code{Aest}}{Estimated proportion matrix from Approach 2.}

\item{\code{Sest}}{Estimated subpopulation-specific expression matrix from
Approach 2.}

\item{\code{Aest.proj}}{Estimated proportion matrix from Approach 2, before
removing scale ambiguity.}

\item{\code{Ascale}}{The estimated scales to remove scale ambiguity
of each column vector in Aest. Sum-to-one constraint on each row of
Aest is used for scale estimation.}

\item{\code{AestO}}{Estimated proportion matrix from Approach 3.}

\item{\code{SestO}}{Estimated subpopulation-specific expression matrix from
Approach 3.}

\item{\code{AestO.proj}}{Estimated proportion matrix from Approach 3, before
removing scale ambiguity.}

\item{\code{AscaleO}}{The estimated scales to remove scale ambiguity
of each column vector in AestO. Sum-to-one constraint on each row of
AestO is used for scale estimation.}

\item{\code{datalength}}{Three values for code length of data. The first is
calculated based on dimension-reduced data. The second and third are
based on the original data.}

\item{\code{mdl}}{Three mdl values. The first is calculated based on
dimension-reduced data. The second and third are based on the original
data.}
}}

