% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AfromMarkers.R
\name{AfromMarkers}
\alias{AfromMarkers}
\title{Proportion matrix estimation from marker genes}
\usage{
AfromMarkers(data, MGlist, scaleRecover = TRUE)
}
\arguments{
\item{data}{A data set that will be internally coerced into a matrix.
Each row is a gene and each column is a sample.
data should be in non-log linear space with non-negative numerical values
(i.e. >= 0).
Missing values are not supported.
All-zero rows will be removed internally.}

\item{MGlist}{A list of vectors, each of which contains known markers
and/or CAM-detected markers for one subpopulation.}

\item{scaleRecover}{If TRUE, scale ambiguity of each column vector
in A matrix is removed based on sum-to-one constraint on each row.}
}
\value{
Return the estimated proportion matrix (A matrix).
}
\description{
This function estimates proportion matrix (A matrix) from observed mixture
expression data based on marker genes.
}
\details{
With the expression levels of subpopulation-specific
marker genes, the relative proportions of constituent subpopulations are
estimated by spatial median using \code{\link[pcaPP]{l1median}}.
Marker genes could be from unsupervised/supervised detection or
from literatures.
Scale ambiguity is optionally removed based on sum-to-one constraint of rows.
}
\examples{
#obtain data and marker genes
data(ratMix3)
S <- ratMix3$S
pMGstat <- MGstatistic(S, c("Liver","Brain","Lung"))
pMGlist.FC <- lapply(c("Liver","Brain","Lung"), function(x)
    rownames(pMGstat)[pMGstat$idx == x & pMGstat$OVE.FC > 10])

#estimate A matrix from markers
Aest <- AfromMarkers(ratMix3$X, pMGlist.FC)
}
