% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\docType{methods}
\name{AS-accessor}
\alias{AS-accessor}
\alias{Amat}
\alias{Smat}
\alias{Amat,CAMObj-method}
\alias{Amat,CAMASObj-method}
\alias{Smat,CAMObj-method}
\alias{Smat,CAMASObj-method}
\title{Deconvoluted matrix accessors}
\usage{
Amat(x, ...)

Smat(x, ...)

\S4method{Amat}{CAMObj}(x, k, usingPCA = TRUE)

\S4method{Amat}{CAMASObj}(x, usingPCA = TRUE)

\S4method{Smat}{CAMObj}(x, k, usingPCA = TRUE)

\S4method{Smat}{CAMASObj}(x, usingPCA = TRUE)
}
\arguments{
\item{x}{a \code{\link{CAMObj}} object or a \code{\link{CAMASObj}} object.}

\item{...}{additional argument list.}

\item{k}{subpopulation number}

\item{usingPCA}{If TRUE, A matrix is estimated by transforming
dimension-reduced A matrix back to original space. Otherwise, A matrix is
directly estimated in original data space. The default is TRUE.}
}
\value{
Estimated A matrix or S matrix.
}
\description{
Accessors to proportion matrix and subpopulation-specific expression matrix
estimated by CAM.
}
\examples{
#obtain data
data(ratMix3)
data <- ratMix3$X

rCAM <- CAM(data, K = 3, dim.rdc = 3, thres.low = 0.30, thres.high = 0.95)
Aest <- Amat(rCAM, 3)
Sest <- Smat(rCAM, 3)

Aest <- Amat(slot(rCAM, "ASestResult")[[1]])
Sest <- Smat(slot(rCAM, "ASestResult")[[1]])
}
