/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.pj.cluster.JobBackendRef;
import edu.rit.pj.cluster.JobFrontendRef;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.concurrent.LinkedBlockingQueue;

public class BackendFileOutputStream
extends OutputStream {
    private JobFrontendRef myJobFrontend;
    private JobBackendRef myJobBackend;
    private LinkedBlockingQueue<Result> myResultQueue = new LinkedBlockingQueue();
    private int ffd;

    BackendFileOutputStream(JobFrontendRef jobFrontendRef, JobBackendRef jobBackendRef) {
        this.myJobFrontend = jobFrontendRef;
        this.myJobBackend = jobBackendRef;
    }

    BackendFileOutputStream(JobFrontendRef jobFrontendRef, JobBackendRef jobBackendRef, int n) {
        this.myJobFrontend = jobFrontendRef;
        this.myJobBackend = jobBackendRef;
        this.ffd = n;
    }

    public void write(int n) throws IOException {
        this.write(new byte[]{(byte)n});
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        this.verifyOpen();
        this.myJobFrontend.outputFileWrite(this.myJobBackend, this.ffd, byArray, n, n2);
        this.getResult();
    }

    public void flush() throws IOException {
        this.verifyOpen();
        this.myJobFrontend.outputFileFlush(this.myJobBackend, this.ffd);
        this.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.verifyOpen();
        try {
            this.myJobFrontend.outputFileClose(this.myJobBackend, this.ffd);
            this.getResult();
        }
        finally {
            this.ffd = 0;
        }
    }

    int open(int n, File file, boolean bl) throws IOException {
        this.myJobFrontend.outputFileOpen(this.myJobBackend, n, file, bl);
        this.ffd = this.getResult().ffd;
        return this.ffd;
    }

    private Result getResult() throws IOException {
        try {
            Result result = this.myResultQueue.take();
            if (result.exc != null) {
                throw result.exc;
            }
            return result;
        }
        catch (InterruptedException interruptedException) {
            InterruptedIOException interruptedIOException = new InterruptedIOException("I/O interrupted");
            interruptedIOException.initCause(interruptedException);
            throw interruptedIOException;
        }
    }

    void putResult(int n, IOException iOException) {
        this.myResultQueue.offer(new Result(n, iOException));
    }

    private void verifyOpen() throws IOException {
        if (this.ffd == 0) {
            throw new IOException("File closed");
        }
    }

    private static class Result {
        public int ffd;
        public IOException exc;

        public Result(int n, IOException iOException) {
            this.ffd = n;
            this.exc = iOException;
        }
    }
}

