/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DataOutputStream
extends FilterOutputStream {
    public DataOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.out.write(bl ? 1 : 0);
    }

    public void writeInt(int n) throws IOException {
        if (-64 <= n && n <= 63) {
            this.out.write(n & 0x7F);
        } else if (-8192 <= n && n <= 8191) {
            this.out.write(n >> 8 & 0x3F | 0x80);
            this.out.write(n);
        } else if (-1048576 <= n && n <= 1048575) {
            this.out.write(n >> 16 & 0x1F | 0xC0);
            this.out.write(n >> 8);
            this.out.write(n);
        } else if (-134217728 <= n && n <= 0x7FFFFFF) {
            this.out.write(n >> 24 & 0xF | 0xE0);
            this.out.write(n >> 16);
            this.out.write(n >> 8);
            this.out.write(n);
        } else {
            this.out.write(n >> 32 & 0xF | 0xF0);
            this.out.write(n >> 24);
            this.out.write(n >> 16);
            this.out.write(n >> 8);
            this.out.write(n);
        }
    }

    public void writeUnsignedInt(int n) throws IOException {
        if (0 <= n && n <= 127) {
            this.out.write(n);
        } else if (128 <= n && n <= 16383) {
            this.out.write(n >> 8 | 0x80);
            this.out.write(n);
        } else if (16384 <= n && n <= 0x1FFFFF) {
            this.out.write(n >> 16 | 0xC0);
            this.out.write(n >> 8);
            this.out.write(n);
        } else if (0x200000 <= n && n <= 0xFFFFFFF) {
            this.out.write(n >> 24 | 0xE0);
            this.out.write(n >> 16);
            this.out.write(n >> 8);
            this.out.write(n);
        } else {
            this.out.write(240);
            this.out.write(n >> 24);
            this.out.write(n >> 16);
            this.out.write(n >> 8);
            this.out.write(n);
        }
    }

    public void writeLong(long l) throws IOException {
        if (-64L <= l && l <= 63L) {
            this.out.write((int)l & 0x7F);
        } else if (-8192L <= l && l <= 8191L) {
            this.out.write((int)(l >> 8) & 0x3F | 0x80);
            this.out.write((int)l);
        } else if (-1048576L <= l && l <= 1048575L) {
            this.out.write((int)(l >> 16) & 0x1F | 0xC0);
            this.out.write((int)(l >> 8));
            this.out.write((int)l);
        } else if (-134217728L <= l && l <= 0x7FFFFFFL) {
            this.out.write((int)(l >> 24) & 0xF | 0xE0);
            this.out.write((int)(l >> 16));
            this.out.write((int)(l >> 8));
            this.out.write((int)l);
        } else if (-17179869184L <= l && l <= 0x3FFFFFFFFL) {
            this.out.write((int)(l >> 32) & 7 | 0xF0);
            this.out.write((int)(l >> 24));
            this.out.write((int)(l >> 16));
            this.out.write((int)(l >> 8));
            this.out.write((int)l);
        } else if (-2199023255552L <= l && l <= 0x1FFFFFFFFFFL) {
            this.out.write((int)(l >> 40) & 3 | 0xF8);
            this.out.write((int)(l >> 32));
            this.out.write((int)(l >> 24));
            this.out.write((int)(l >> 16));
            this.out.write((int)(l >> 8));
            this.out.write((int)l);
        } else if (-281474976710656L <= l && l <= 0x1000000000000L) {
            this.out.write((int)(l >> 48) & 1 | 0xFC);
            this.out.write((int)(l >> 40));
            this.out.write((int)(l >> 32));
            this.out.write((int)(l >> 24));
            this.out.write((int)(l >> 16));
            this.out.write((int)(l >> 8));
            this.out.write((int)l);
        } else if (-36028797018963968L <= l && l <= 0x80000000000000L) {
            this.out.write(254);
            this.out.write((int)(l >> 48));
            this.out.write((int)(l >> 40));
            this.out.write((int)(l >> 32));
            this.out.write((int)(l >> 24));
            this.out.write((int)(l >> 16));
            this.out.write((int)(l >> 8));
            this.out.write((int)l);
        } else {
            this.out.write(255);
            this.out.write((int)(l >> 56));
            this.out.write((int)(l >> 48));
            this.out.write((int)(l >> 40));
            this.out.write((int)(l >> 32));
            this.out.write((int)(l >> 24));
            this.out.write((int)(l >> 16));
            this.out.write((int)(l >> 8));
            this.out.write((int)l);
        }
    }

    public void writeUnsignedLong(long l) throws IOException {
        if (0L <= l && l <= 127L) {
            this.out.write((int)l);
        } else if (128L <= l && l <= 16383L) {
            this.out.write((int)(l >> 8) | 0x80);
            this.out.write((int)l);
        } else if (16384L <= l && l <= 0x1FFFFFL) {
            this.out.write((int)(l >> 16) | 0xC0);
            this.out.write((int)(l >> 8));
            this.out.write((int)l);
        } else if (0x200000L <= l && l <= 0xFFFFFFFL) {
            this.out.write((int)(l >> 24) | 0xE0);
            this.out.write((int)(l >> 16));
            this.out.write((int)(l >> 8));
            this.out.write((int)l);
        } else if (0x10000000L <= l && l <= 0x7FFFFFFFFL) {
            this.out.write((int)(l >> 32) | 0xF0);
            this.out.write((int)(l >> 24));
            this.out.write((int)(l >> 16));
            this.out.write((int)(l >> 8));
            this.out.write((int)l);
        } else if (0x800000000L <= l && l <= 0x3FFFFFFFFFFL) {
            this.out.write((int)(l >> 40) | 0xF8);
            this.out.write((int)(l >> 32));
            this.out.write((int)(l >> 24));
            this.out.write((int)(l >> 16));
            this.out.write((int)(l >> 8));
            this.out.write((int)l);
        } else if (0x40000000000L <= l && l <= 0x1FFFFFFFFFFFFL) {
            this.out.write((int)(l >> 48) | 0xFC);
            this.out.write((int)(l >> 40));
            this.out.write((int)(l >> 32));
            this.out.write((int)(l >> 24));
            this.out.write((int)(l >> 16));
            this.out.write((int)(l >> 8));
            this.out.write((int)l);
        } else if (0x2000000000000L <= l && l <= 0xFFFFFFFFFFFFFFL) {
            this.out.write(254);
            this.out.write((int)(l >> 48));
            this.out.write((int)(l >> 40));
            this.out.write((int)(l >> 32));
            this.out.write((int)(l >> 24));
            this.out.write((int)(l >> 16));
            this.out.write((int)(l >> 8));
            this.out.write((int)l);
        } else {
            this.out.write(255);
            this.out.write((int)(l >> 56));
            this.out.write((int)(l >> 48));
            this.out.write((int)(l >> 40));
            this.out.write((int)(l >> 32));
            this.out.write((int)(l >> 24));
            this.out.write((int)(l >> 16));
            this.out.write((int)(l >> 8));
            this.out.write((int)l);
        }
    }

    public void writeFloat(float f) throws IOException {
        int n = Float.floatToRawIntBits(f);
        this.out.write(n >> 24);
        this.out.write(n >> 16);
        this.out.write(n >> 8);
        this.out.write(n);
    }

    public void writeDouble(double d) throws IOException {
        long l = Double.doubleToRawLongBits(d);
        this.out.write((int)(l >> 56));
        this.out.write((int)(l >> 48));
        this.out.write((int)(l >> 40));
        this.out.write((int)(l >> 32));
        this.out.write((int)(l >> 24));
        this.out.write((int)(l >> 16));
        this.out.write((int)(l >> 8));
        this.out.write((int)l);
    }

    public void writeString(String string) throws IOException {
        int n = string.length();
        this.writeUnsignedInt(n);
        for (int i = 0; i < n; ++i) {
            this.writeUnsignedInt(string.charAt(i));
        }
    }
}

